/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeI18n;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.ContentMaterial;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ContentMaterialSkull
extends ContentMaterial {
    private static final String SKULL_FROM = TConstruct.makeTranslationKey("book", "material.skull_from");
    protected transient IDisplayableCastingRecipe skullRecipe = null;
    private transient boolean searchedSkullRecipe = false;
    protected transient List<ItemStack> skullStacks = null;

    public ContentMaterialSkull(MaterialVariantId material, boolean detailed) {
        super(material, detailed);
    }

    @Nullable
    private IDisplayableCastingRecipe getSkullRecipe() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (!this.searchedSkullRecipe && world != null) {
            this.skullRecipe = world.m_7465_().m_44013_((RecipeType)TinkerRecipeTypes.CASTING_BASIN.get()).stream().filter(recipe -> recipe instanceof IDisplayableCastingRecipe).map(recipe -> (IDisplayableCastingRecipe)((Object)recipe)).filter(recipe -> {
                ItemStack output = recipe.getOutput();
                return output.m_41720_() == TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET) && MaterialIdNBT.from(output).getMaterial(0).getId().toString().equals(this.materialName);
            }).findFirst().orElse(null);
            this.searchedSkullRecipe = true;
        }
        return this.skullRecipe;
    }

    @Override
    public Component getTitleComponent() {
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null) {
            return skullRecipe.getOutput().m_41786_();
        }
        return super.getTitleComponent();
    }

    @Override
    public List<ItemStack> getDisplayStacks() {
        List<ItemStack> skulls;
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(skulls = skullRecipe.getCastItems()).isEmpty()) {
            return skulls;
        }
        return super.getDisplayStacks();
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)SkullStats.ID);
    }

    @Override
    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialVariantId materialId) {
        List<ItemStack> casts;
        displayTools.add(new TinkerItemElement(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(materialId)));
        super.addPrimaryDisplayItems(displayTools, materialId);
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(casts = skullRecipe.getCastItems()).isEmpty()) {
            TinkerItemElement elementItem = new TinkerItemElement(0, 0, 1.0f, casts);
            elementItem.tooltip = ImmutableList.of((Object)new TranslatableComponent(SKULL_FROM, new Object[]{casts.get(0).m_41786_()}));
            displayTools.add(elementItem);
        }
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        MaterialVariantId materialVariant = this.getMaterialVariant();
        this.addTitle(list, this.getTitle(), true, MaterialTooltipCache.getColor(materialVariant).m_131265_());
        this.addDisplayItems(list, rightSide ? 164 : 0, materialVariant);
        int top = this.getTitleHeight();
        int left = rightSide ? 0 : 22;
        int y = top + 5;
        int x = left + 5;
        int w = 162;
        MaterialId materialId = materialVariant.getId();
        int skullTraits = this.addStatsDisplay(x, y, w, list, materialId, SkullStats.ID);
        y += 65;
        String textKey = String.format(this.detailed ? "material.%s.%s.skull_encyclopedia" : "material.%s.%s.skull_flavor", materialId.m_135827_(), materialId.m_135815_());
        if (I18n.m_118936_((String)textKey)) {
            Object translated = ForgeI18n.getPattern((String)textKey);
            if (!this.detailed) {
                translated = "\"" + (String)translated + "\"";
            }
            TextData flavourData = new TextData((String)translated);
            flavourData.italic = !this.detailed;
            list.add((BookElement)new TextElement(x, y + 10 * skullTraits, w, 60, new TextData[]{flavourData}));
        }
    }
}

